﻿using System.Collections.Generic;
using System.Runtime.Serialization;
using InfoWorld.HL7.ITS;

namespace BMS.Facade.Data
{
    /// <summary>
    /// Icon association class.
    /// </summary>
    [DataContract]
    public class IconAssociation
    {
        /// <summary>
        /// Gets or sets the bed.
        /// </summary>
        /// <value>
        /// The bed.
        /// </value>
        [DataMember]
        public Place Bed { get; set; }

        /// <summary>
        /// Gets or sets the patient.
        /// </summary>
        /// <value>
        /// The patient.
        /// </value>
        [DataMember]
        public Patient Patient { get; set; }

        /// <summary>
        /// Gets or sets the facility.
        /// </summary>
        /// <value>
        /// The facility.
        /// </value>
        [DataMember]
        public Place Facility { get; set; }

        /// <summary>
        /// Gets or sets the list icon flag ids of bed.
        /// </summary>
        /// <value>
        /// The list icon flag ids of bed.
        /// </value>
        [DataMember]
        public List<int> ListIconFlagIdsOfBed { get; set; }

        /// <summary>
        /// Gets or sets the list icon flag ids of patient.
        /// </summary>
        /// <value>
        /// The list icon flag ids of patient.
        /// </value>
        [DataMember]
        public List<int> ListIconFlagIdsOfPatient { get; set; }

        /// <summary>
        /// Gets or sets the list icon flag facility ids of bed.
        /// </summary>
        /// <value>
        /// The list icon flag facility ids of bed.
        /// </value>
        [DataMember]
        public List<int> ListIconFlagFacilityIdsOfBed { get; set; }

        /// <summary>
        /// Gets or sets the list icon flag facility ids of patient.
        /// </summary>
        /// <value>
        /// The list icon flag facility ids of patient.
        /// </value>
        [DataMember]
        public List<int> ListIconFlagFacilityIdsOfPatient { get; set; }

        /// <summary>
        /// Gets or sets the waiting list patient id.
        /// </summary>
        /// <value>
        /// The waiting list patient id.
        /// </value>
        [DataMember]
        public II WaitingListPatientId { get; set; }

        /// <summary>
        /// Gets or sets the waiting list info.
        /// </summary>
        /// <value>
        /// The waiting list info.
        /// </value>
        [DataMember]
        public string WaitingListInfo { get; set; }
    }
}
